% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{xml_node_create}
\alias{xml_node_create}
\title{create xml_node from R objects}
\usage{
xml_node_create(
  xml_name,
  xml_children = NULL,
  xml_attributes = NULL,
  escapes = FALSE,
  declaration = FALSE
)
}
\arguments{
\item{xml_name}{the name of the new xml_node}

\item{xml_children}{character vector children attached to the xml_node}

\item{xml_attributes}{named character vector of attributes for the xml_node}

\item{escapes}{bool if escapes should be used}

\item{declaration}{bool if declaration should be imported}
}
\description{
takes xml_name, xml_children and xml_attributes to create a new
xml_node.
}
\details{
if xml_children or xml_attributes should be empty, use NULL
}
\examples{
xml_name <- "a"
# "<a/>"
xml_node_create(xml_name)

xml_child <- "openxlsx"
# "<a>openxlsx</a>"
xml_node_create(xml_name, xml_children = xml_child)

xml_attr <- c(foo = "baz", qux = "quux")
# "<a foo=\"baz\" qux=\"quux\"/>"
xml_node_create(xml_name, xml_attributes = xml_attr)

# "<a foo=\"baz\" qux=\"quux\">openxlsx</a>"
xml_node_create(xml_name, xml_children = xml_child, xml_attributes = xml_attr)
}
