% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_periodic.R
\name{make_periodic}
\alias{make_periodic}
\title{Make an forecast matrix with a periodic time signal.}
\usage{
make_periodic(time, kseq, period, offset = 0, tstep = NA)
}
\arguments{
\item{time}{vector of times of class "POSIXct" "POSIXt".}

\item{kseq}{vector of integers, representing the desired "k-steps ahead".}

\item{period}{a numeric setting the length of the period in seconds.}

\item{offset}{a numeric setting an offset in the period start in seconds.}

\item{tstep}{step time of k in seconds.}
}
\value{
Returns a forecast matrix (data.frame) with rownames = times, colnames = k1, k2, k3, ...
The content of the data frame is the hour of day.
}
\description{
This function creates a data.frame with k-steps-ahead values of a periodic time signal,
such that it can be added to a data.list and used inputs to a forecast model.
}
\examples{
# Create a time sequence of 30 min sample period
tseq <- seq(ct("2019-01-01"), ct("2019-02-01 12:00"), by=1800)

# Make the three hourly periodic sequence
make_periodic(tseq, 1:10, 3*3600)

# With an offset of one hour
make_periodic(tseq, 1:10, 3*3600, 3600)

}
\seealso{
make_tday
}
\keyword{data.frame}
\keyword{lags}
\keyword{periodic}
