% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_data.frame.R
\name{print_data.frame}
\alias{print_data.frame}
\title{Print (abbreviated) \code{data.frame}}
\usage{
print_data.frame(
  x,
  rows = NULL,
  cols = NULL,
  digits = NULL,
  row.names = TRUE,
  col.names = TRUE
)
}
\arguments{
\item{x}{[\code{data.frame}]\cr
A \code{data.frame}.}

\item{rows, cols}{[\code{integer(1)} | \code{NULL} ]\cr
The number of rows or columns to be printed, greater or equal \code{2}.

Printing is abbreviated in the middle.

Can be \code{NULL} to print everything.}

\item{digits}{[\code{integer(1)} | \code{NULL} ]\cr
The number of decimal places to be used.

Negative values are allowed, resulting in rounding to a power of ten.

Can be \code{NULL} to not round.}

\item{row.names, col.names}{[\code{logical(1)}]\cr
Print row names or column names?}
}
\value{
Invisibly returns \code{x}.
}
\description{
This function prints a (possibly abbreviated) \code{data.frame}.
}
\examples{
x <- data.frame(1:10, LETTERS[1:10], stats::rnorm(10))
print_data.frame(x, rows = 7)
print_data.frame(x, rows = 7, cols = 2)
print_data.frame(x, rows = 7, cols = 2, digits = 1)
print_data.frame(x, rows = 7, cols = 2, digits = 1, row.names = FALSE)
print_data.frame(x, rows = 7, cols = 2, digits = 1, col.names = FALSE)
}
\seealso{
Other package helpers: 
\code{\link{Dictionary}},
\code{\link{Storage}},
\code{\link{check_missing}()},
\code{\link{find_namespace_calls}()},
\code{\link{identical_structure}()},
\code{\link{input_check_response}()},
\code{\link{match_arg}()},
\code{\link{package_logo}()},
\code{\link{print_matrix}()},
\code{\link{system_information}()},
\code{\link{unexpected_error}()},
\code{\link{user_confirm}()}
}
\concept{package helpers}
\keyword{packaging}
