% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equidistant_vectors.R
\name{equidistant_vectors}
\alias{equidistant_vectors}
\title{Generate equidistant vectors in Euclidean space}
\usage{
equidistant_vectors(dim, n = dim + 1, dist = 1, center = rep(0, dim))
}
\arguments{
\item{dim}{[\code{integer(1)}]\cr
The dimension.}

\item{n}{[\code{integer(1)}]\cr
The number of vertices to return. Cannot be larger than \code{dim + 1}.}

\item{dist}{[\code{numeric(1)}]\cr
Desired pairwise Euclidean distance between any two vertices.}

\item{center}{[\code{numeric(dim)}]\cr
Desired center.}
}
\value{
A matrix, where each column is a vertex of the simplex.
}
\description{
This function constructs the coordinates of vertices of a regular simplex
in \eqn{\mathbb{R}^{\code{dim}}} and returns the first \code{n} of them,
\itemize{
\item scaled so that the pairwise Euclidean distance between any two vertices
equals \code{dist},
\item and centered so their centroid is at \code{center}.
}
}
\examples{
dim <- n <- 3
(dist <- runif(1))
(center <- rnorm(dim))
(V <- equidistant_vectors(dim = dim, n = n, dist = dist, center = center))
rowMeans(V)
dist(t(V))
}
\seealso{
Other vector helpers: 
\code{\link{check_numeric_vector}()},
\code{\link{check_probability_vector}()},
\code{\link{chunk_vector}()},
\code{\link{insert_vector_entry}()},
\code{\link{map_indices}()},
\code{\link{match_numerics}()},
\code{\link{permutations}()},
\code{\link{split_vector_at}()},
\code{\link{subsets}()},
\code{\link{vector_occurrence}()}
}
\concept{vector helpers}
\keyword{simulation}
