% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_columns_data.frame.R
\name{delete_columns_data.frame}
\alias{delete_columns_data.frame}
\title{Deleting \code{data.frame} columns}
\usage{
delete_columns_data.frame(df, column_names)
}
\arguments{
\item{df}{[\code{data.frame}]\cr
A \code{data.frame}.}

\item{column_names}{[\code{character()}]\cr
The name(s) of column(s) of \code{df} to delete.}
}
\value{
The input \code{df} without the columns defined by \code{column_names}.
}
\description{
This function deletes columns of a \code{data.frame} by name.
}
\examples{
df <- data.frame("label" = c("A", "B"), "number" = 1:10)
delete_columns_data.frame(df = df, column_names = "label")
delete_columns_data.frame(df = df, column_names = "number")
delete_columns_data.frame(df = df, column_names = c("label", "number"))
}
\seealso{
Other data.frame helpers: 
\code{\link{group_data.frame}()},
\code{\link{occurrence_info}()},
\code{\link{round_data.frame}()}
}
\concept{data.frame helpers}
\keyword{transformation}
