% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlated_regressors.R
\name{correlated_regressors}
\alias{correlated_regressors}
\title{Simulate correlated regressor values}
\usage{
correlated_regressors(
  labels,
  n = 100,
  marginals = list(),
  correlation = diag(length(labels)),
  verbose = FALSE
)
}
\arguments{
\item{labels}{[\code{character()}]\cr
Unique labels for the regressors.}

\item{n}{[\code{integer(1)}]\cr
The number of values per regressor.}

\item{marginals}{[\code{list()}]\cr
Optionally marginal distributions for regressors. If not specified,
standard normal marginal distributions are used.

Each list entry must be named according to a regressor label, and the
following distributions are currently supported:
\describe{
\item{discrete distributions}{
\itemize{
\item Poisson: \code{list(type = "poisson", lambda = ...)}
\item categorical: \code{list(type = "categorical", p = c(...))}
}
}
\item{continuous distributions}{
\itemize{
\item normal: \code{list(type = "normal", mean = ..., sd = ...)}
\item uniform: \code{list(type = "uniform", min = ..., max = ...)}
}
}
}}

\item{correlation}{[\code{matrix()}]\cr
A correlation matrix of dimension \code{length(labels)}, where the
\code{(p, q)}-th entry defines the correlation between regressor
\code{labels[p]} and \code{labels[q]}.}

\item{verbose}{[\code{logical(1)}]\cr
Print information about the simulated regressors?}
}
\value{
A \code{data.frame} with \code{n} rows and \code{length(labels)} columns.
}
\description{
This function simulates regressor values from various marginal distributions
with custom correlations.
}
\examples{
labels <- c("P", "C", "N1", "N2", "U")
n <- 100
marginals <- list(
  "P" = list(type = "poisson", lambda = 2),
  "C" = list(type = "categorical", p = c(0.3, 0.2, 0.5)),
  "N1" = list(type = "normal", mean = -1, sd = 2),
  "U" = list(type = "uniform", min = -2, max = -1)
)
correlation <- matrix(
  c(1, -0.3, -0.1, 0, 0.5,
    -0.3, 1, 0.3, -0.5, -0.7,
    -0.1, 0.3, 1, -0.3, -0.3,
    0, -0.5, -0.3, 1, 0.1,
    0.5, -0.7, -0.3, 0.1, 1),
  nrow = 5, ncol = 5
)
data <- correlated_regressors(
  labels = labels, n = n, marginals = marginals, correlation = correlation
)
head(data)
}
\references{
This function heavily depends on the \code{{SimMultiCorrData}} package.
}
\seealso{
Other simulation helpers: 
\code{\link{Simulator}},
\code{\link{ddirichlet_cpp}()},
\code{\link{dmixnorm_cpp}()},
\code{\link{dmvnorm_cpp}()},
\code{\link{dtnorm_cpp}()},
\code{\link{dwishart_cpp}()},
\code{\link{gaussian_tv}()},
\code{\link{simulate_markov_chain}()}
}
\concept{simulation helpers}
\keyword{simulation}
