% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expressionFromAttributeValuesCount.R
\name{expressionFromAttributeValuesCount}
\alias{expressionFromAttributeValuesCount}
\title{Generates a query expression for matching a transcript/participant attribute, for use with
\link{getMatches}}
\usage{
expressionFromAttributeValuesCount(
  transcript.attribute,
  comparison = "==",
  count
)
}
\arguments{
\item{transcript.attribute}{The transcript attribute to filter by.}

\item{comparison}{A string representing the operator to use for comparison, one of
"<", "<=", "==", "!=", ">=", ">".}

\item{count}{The number to compare the count of values to.}
}
\value{
A transcript query expression which can be passed as the
transcript.expression parameter of \link{getMatches} or the expression parameter
of \link{getMatchingTranscriptIds}
}
\description{
This function generates a query expression fragment which can be passed as
the transcript.expression or participant.expression parameter of \link{getMatches}, (or
the expression parameter of \link{getMatchingTranscriptIds} or
\link{getMatchingParticipantIds}) matching by the number of values for a given
attribute.
}
\details{
The attribute defined by transcript.attribute is expected to have possibly more than
one value, although single-value attributes may have 0 or 1 values, and this function
can be used to distinguish these two possibilities as well.
}
\examples{
\dontrun{
## Search only transcripts including multilingual participants
results <- getMatches(labbcat.url, list(segment="I"),
                      participant.expression = expressionFromAttributeValuesCount(
                            "participant_languages", ">=", 2))

## Search only transcripts with no restrictions specified
results <- getMatches(labbcat.url, list(segment="I"),
                      transcript.expression = expressionFromAttributeValuesCount(
                            "transcript_restrictions", "==", 0))
}
}
\seealso{
\link{expressionFromAttributeValues}

\link{expressionFromTranscriptTypes}

\link{expressionFromIds}

\link{getMatches}
}
\keyword{search}
