% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nuts_get_data.R
\name{nuts_get_data}
\alias{nuts_get_data}
\title{Return classified NUTS data}
\usage{
nuts_get_data(data)
}
\arguments{
\item{data}{A nuts.classified object returned by \code{\link[=nuts_classify]{nuts_classify()}}.}
}
\value{
A tibble containing the original data with the classified NUTS version, level, and country.
}
\description{
\code{nuts_get_data()} returns the classified data after running \code{nuts_classify()}.
}
\details{
Console messages can be controlled with \code{rlang::local_options(nuts.verbose = "quiet")} to silence messages and
\code{nuts.verbose = "verbose"} to switch messages back on.
}
\examples{
library(dplyr)

# Load EUROSTAT data of manure storage deposits
data(manure)

# Classify version of NUTS 2 codes in Germany
classified <- manure \%>\%
   filter(nchar(geo) == 4) \%>\%
   filter(indic_ag == 'I07A_EQ_Y') \%>\%
   filter(grepl('^DE', geo)) \%>\%
   filter(time == 2003) \%>\%
   select(-indic_ag, -time) \%>\%
   # Data varies at the NUTS code level
   nuts_classify(nuts_code = 'geo')

nuts_get_data(classified)

}
