% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_utilityFunctions.R
\name{getHostData}
\alias{getHostData}
\title{Extracts specific data from a \code{nosoiSim} object}
\usage{
getHostData(
  nosoi.output,
  what = c("table.hosts", "N.infected", "table.state", "popStructure"),
  pop = "A"
)
}
\arguments{
\item{nosoi.output}{an object of class \code{nosoiSim}}

\item{what}{the data to get, among \code{table.hosts}, \code{N.infected}, \code{table.state} or \code{popStructure}.}

\item{pop}{the population to be extracted (one of "A" or "B")}
}
\value{
Returns a \code{\link[data.table]{data.table}} with the requested data.
}
\description{
This function extracts data user-defined data (i.e. \code{table.hosts}, \code{N.infected}, \code{table.state} or \code{popStructure}) from a \code{\link{nosoiSim}} object.
}
\examples{
\donttest{
t_incub_fct <- function(x){rnorm(x,mean = 5,sd=1)}
p_max_fct <- function(x){rbeta(x,shape1 = 5,shape2=2)}
p_Exit_fct  <- function(t){return(0.08)}

proba <- function(t,p_max,t_incub){
  if(t <= t_incub){p=0}
  if(t >= t_incub){p=p_max}
  return(p)
}

time_contact <- function(t){round(rnorm(1, 3, 1), 0)}

test.nosoi <- nosoiSim(type="single", popStructure="none",
                       length=40,
                       max.infected=100,
                       init.individuals=1,
                       nContact=time_contact,
                       param.nContact=NA,
                       pTrans = proba,
                       param.pTrans = list(p_max=p_max_fct,
                                           t_incub=t_incub_fct),
                       pExit=p_Exit_fct,
                       param.pExit=NA)


data.extracted <- getHostData(test.nosoi, "table.hosts", "A")
}
}
\seealso{
To directly extract \code{table.hosts} or \code{table.state}, you can also use \code{\link{getTableHosts}} and \code{\link{getTableState}} respectively.
}
