% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SStemp.R
\name{SStemp3}
\alias{SStemp3}
\alias{temp3}
\title{self start for Collatz temperature response}
\usage{
temp3(x, t.m, t.l, t.h)

SStemp3(x, t.m, t.l, t.h)
}
\arguments{
\item{x}{input vector (x) which is normally \sQuote{temperature}.}

\item{t.m}{medium temperature}

\item{t.l}{low temperature}

\item{t.h}{high temperature}
}
\value{
temp3: vector of the same length as x using a temp function
}
\description{
Self starter for Collatz temperature response function
}
\details{
Collatz GJ , Ribas-Carbo M Berry JA (1992) Coupled Photosynthesis-Stomatal Conductance Model for Leaves of C4 Plants. Functional Plant Biology 19, 519-538.
https://doi.org/10.1071/PP9920519
}
\examples{
\donttest{
## A temperature response function
require(ggplot2)
set.seed(1234)
x <- 1:50
y <- temp3(x, 25, 13, 36) + rnorm(length(x), sd = 0.05)
dat1 <- data.frame(x = x, y = y)
fit1 <- nls(y ~ SStemp3(x, t.m, t.l, t.h), data = dat1)

ggplot(data = dat1, aes(x, y)) + 
  geom_point() + 
  geom_line(aes(y = fitted(fit1)))
}
}
