% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLik1.R
\name{logLik1.lme}
\alias{logLik1.lme}
\title{Calculates contribution of one subject to the log-likelihood for an \code{lme} object}
\usage{
\method{logLik1}{lme}(modfit, dt1, dtInit)
}
\arguments{
\item{modfit}{an \code{\link[nlme:lme]{lme}} object representing a model fitted using maximum likelihood.}

\item{dt1}{a data frame with data for one subject, for whom the log-likelihood function is to be evaluated.}

\item{dtInit}{an optional auxiliary data frame.}
}
\value{
Numeric scalar value representing the contribution of a given subject to the overall log-likelihood returned by \code{\link[nlme:logLik.lme]{logLik}} applied to an \code{\link[nlme:lme]{lme}} object defined by the \code{modfit} argument.
}
\description{
This is a method for the \code{\link{logLik1}} generic function.
}
\details{
Calculates the profile likelihood (with beta profiled out) for one subject.
Data with one level of grouping only. The correlation component in \code{modelStruct} is not implemented.
}
\examples{

library(nlme)
data(armd, package = "nlmeU")
lm3.form <- visual ~ visual0 + time + treat.f 
fm16.5ml <- lme(lm3.form,                         
                random = list(subject = pdDiag(~time)), 
                weights = varPower(form = ~time),
                data = armd, method = "ML") # M16.5
df1 <- subset(armd, subject = "1")          # Panel R20.7
logLik1(fm16.5ml, df1)

}
\author{
Andrzej Galecki and Tomasz Burzykowski
}
