% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agreementIndex.R
\name{agreementIndex}
\alias{agreementIndex}
\title{Calculate Agreement Indices.}
\usage{
agreementIndex(CRA, CRAError, calCurve = "intcal20", theta, verbose = TRUE)
}
\arguments{
\item{CRA}{vector of C14 ages.}

\item{CRAError}{vector of C14 errors associated with \code{CRA}.}

\item{calCurve}{character string naming a calibration curve, one between 'intcal20','intcal13','shcal20','shcal13','marine13' and 'marine20'.}

\item{theta}{a Matrix containing the posterior samples of each date.}

\item{verbose}{a logical variable indicating whether extra information on progress should be reported. Default is TRUE.}
}
\value{
a list containing the individual and overall agreement indices.
}
\description{
Computes OxCal-style (Bronk-Ramsey 1995) individual and overall agreement index for evaluating model consistency.
}
\references{
Bronk-Ramsey, C. (1995). Radiocarbon Calibration and Analysis of Stratigraphy: The OxCal Program. Radiocarbon, 37(2), 425–430.
}
