#' @title IntCal20 radiocarbon age calibration curve for the Northern hemisphere. 
#' @format A data.frame with the following fields:
#' \describe{
#' \item{\code{CalBP}}{ID of each radiocarbon date}
#' \item{\code{C14Age}}{Radiocarbon age in 14C years BP}
#' \item{\code{C14Age.sigma}}{Radiocarbon age error}
#' \item{\code{Delta14C}}{Labcode of the radiocarbon date}
#' \item{\code{Delta14C.sigma}}{Material of the dated sample}
#'}
#' @source https://intcal.org/curves/intcal20.14c
#' @references
#' Reimer, P. J., Austin, W. E. N., Bard, E., Bayliss, A., Blackwell, P. G., Ramsey, C. B., et al. (2020). The IntCal20 Northern Hemisphere Radiocarbon Age Calibration Curve (0–55 cal kBP). Radiocarbon, 62(4), 725–757. https://doi.org/10.1017/RDC.2020.41
"intcal20"

#' @title IntCal20 radiocarbon age calibration curve for the Southern hemisphere. 
#' @format A data.frame with the following fields:
#' \describe{
#' \item{\code{CalBP}}{ID of each radiocarbon date}
#' \item{\code{C14Age}}{Radiocarbon age in 14C years BP}
#' \item{\code{C14Age.sigma}}{Radiocarbon age error}
#' \item{\code{Delta14C}}{Labcode of the radiocarbon date}
#' \item{\code{Delta14C.sigma}}{Material of the dated sample}
#'}
#' @source https://intcal.org/curves/shcal20.14c
#' @references
#' Reimer, P. J., Austin, W. E. N., Bard, E., Bayliss, A., Blackwell, P. G., Ramsey, C. B., et al. (2020). The IntCal20 Northern Hemisphere Radiocarbon Age Calibration Curve (0–55 cal kBP). Radiocarbon, 62(4), 725–757. https://doi.org/10.1017/RDC.2020.41
"shcal20"

#' @title Marine20 radiocarbon age calibration curve. 
#' @format A data.frame with the following fields:
#' \describe{
#' \item{\code{CalBP}}{ID of each radiocarbon date}
#' \item{\code{C14Age}}{Radiocarbon age in 14C years BP}
#' \item{\code{C14Age.sigma}}{Radiocarbon age error}
#' \item{\code{Delta14C}}{Labcode of the radiocarbon date}
#' \item{\code{Delta14C.sigma}}{Material of the dated sample}
#'}
#' @source https://intcal.org/curves/marine20.14c
#' @references
#' Heaton, T. J., Köhler, P., Butzin, M., Bard, E., Reimer, R. W., Austin, W. E. N., et al. (2020). Marine20—The Marine Radiocarbon Age Calibration Curve (0–55,000 cal BP). Radiocarbon, 62(4), 779–820. https://doi.org/10.1017/RDC.2020.68
"marine20"