% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ESPNEvent.R
\name{get_espn_events}
\alias{get_espn_events}
\title{Get ESPN events (games) by start and end dates}
\usage{
get_espn_events(start_date = 20241004, end_date = 20250624)
}
\arguments{
\item{start_date}{integer Start Date in YYYYMMDD}

\item{end_date}{integer End Date in YYYYMMDD}
}
\value{
tibble with one row per event (game)
}
\description{
\code{get_espn_events()} retrieves ESPN hyperlinks for each event; the hyperlinks are formatted in \verb{base/events/\{ESPN Event ID\}?query}. Access \code{get_seasons()} for \code{start_season} and \code{end_season} references. May soon be reworked to only return the ESPN Event IDs.
}
\examples{
ESPN_events_20242025 <- get_espn_events(start_date=20241004, end_date=20250624)
}
