% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/transform_lr.R
\docType{methods}
\name{transform_lr}
\alias{transform_lr}
\alias{transform_lr-method}
\alias{transform_lr,CompositionMatrix-method}
\alias{transform_lr,GroupedComposition-method}
\title{Pairwise Log-Ratios (LR)}
\usage{
transform_lr(object, ...)

\S4method{transform_lr}{CompositionMatrix}(object, weights = FALSE)

\S4method{transform_lr}{GroupedComposition}(object, weights = FALSE)
}
\arguments{
\item{object}{A \code{\linkS4class{CompositionMatrix}} object.}

\item{...}{Currently not used.}

\item{weights}{A \code{\link{logical}} scalar: should varying weights (column means)
be computed? If \code{FALSE} (the default), equally-weighted parts are used.
Alternatively, a positive \code{\link{numeric}} vector of weights can be specified
(will be rescaled to sum to \eqn{1}). Weights will be used internally by
other methods (e.g. \code{\link[=variance]{variance()}}).}
}
\value{
A \code{\linkS4class{LR}} object.
}
\description{
Computes all pairwise log-ratio transformation.
}
\examples{
## Data from Aitchison 1986
data("hongite")

## Coerce to compositional data
coda <- as_composition(hongite)

## Pairwise log-ratio
lr <- transform_lr(coda)
}
\references{
Aitchison, J. (1986). \emph{The Statistical Analysis of Compositional Data}.
London: Chapman and Hall.

Greenacre, M. J. (2019). \emph{Compositional Data Analysis in Practice}.
Boca Raton: CRC Press.

Greenacre, M. J. (2021). Compositional Data Analysis. \emph{Annual Review of
Statistics and Its Application}, 8(1): 271-299.
\doi{10.1146/annurev-statistics-042720-124436}.
}
\seealso{
Other log-ratio transformations: 
\code{\link{transform_alr}()},
\code{\link{transform_clr}()},
\code{\link{transform_ilr}()},
\code{\link{transform_inverse}()},
\code{\link{transform_plr}()}
}
\author{
N. Frerebeau
}
\concept{log-ratio transformations}
