% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_graph.R
\name{rgraph_er}
\alias{rgraph_er}
\alias{bernoulli}
\title{Erdos-Renyi model}
\usage{
rgraph_er(
  n = 10,
  t = 1,
  p = 0.01,
  undirected = getOption("diffnet.undirected"),
  weighted = FALSE,
  self = getOption("diffnet.self"),
  as.edgelist = FALSE
)
}
\arguments{
\item{n}{Integer. Number of vertices}

\item{t}{Integer. Number of time periods}

\item{p}{Double. Probability of a link between ego and alter.}

\item{undirected}{Logical scalar. Whether the graph is undirected or not.}

\item{weighted}{Logical. Whether the graph is weighted or not.}

\item{self}{Logical. Whether it includes self-edges.}

\item{as.edgelist}{Logical. When TRUE the graph is presented as an edgelist
instead of an adjacency matrix.}
}
\value{
A graph represented by an adjacency matrix (if \code{t=1}), or an array of
adjacency matrices (if \code{t>1}).
}
\description{
Generates a bernoulli random graph.
}
\details{
For each pair of nodes \eqn{\{i,j\}}{{i,j}}, an edge is created
with probability \eqn{p}, this is, \eqn{Pr\{Link i-j\} = Pr\{x<p\}}{%
Pr{Link i-j}}, where \eqn{x} is drawn from a \eqn{Uniform(0,1)}.

When \code{weighted=TRUE}, the strength of ties is given by
the random draw \eqn{x} used to compare against \eqn{p}, hence, if \eqn{x < p}
then the strength will be set to \eqn{x}.

In the case of dynamic graphs, the algorithm is repeated \eqn{t} times, so the
networks are uncorrelated.
}
\note{
The resulting adjacency matrix is store as a dense matrix, not as a
sparse matrix, hence the user should be careful when choosing the size of
the network.
}
\examples{
# Setting the seed
set.seed(13)

# Generating an directed graph
rgraph_er(undirected=FALSE, p = 0.1)

# Comparing P(tie)
x <- rgraph_er(1000, p=.1)
sum(x)/length(x)

# Several period random gram
rgraph_er(t=5)
}
\references{
Barabasi, Albert-Laszlo. "Network science book" Retrieved November 1 (2015)
\url{https://networksciencebook.com}.
}
\seealso{
Other simulation functions: 
\code{\link{permute_graph}()},
\code{\link{rdiffnet}()},
\code{\link{rewire_graph}()},
\code{\link{rgraph_ba}()},
\code{\link{rgraph_ws}()},
\code{\link{ring_lattice}()}
}
\author{
George G. Vega Yon
}
\concept{Bernoulli Random graph}
\concept{Erdos-Renyi random graph}
\concept{simulation functions}
\keyword{distribution}
