% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InferenceFunctions.R
\name{nbp.caliper}
\alias{nbp.caliper}
\title{non-bipartite matching with treatment assignment caliper}
\usage{
nbp.caliper(Z, X, pmat, xi = 0, M = 0)
}
\arguments{
\item{Z}{a 2I-length vector of treatment values, which must be numeric.}

\item{X}{a 2I x k matrix of covariate values, which must be numeric.}

\item{pmat}{a 2I x 2I symmetric matrix where the diagonals equal zero, and the
off-diagonal elements (i, j) contain the probability the ith observation has
Z = max(Z_i, Z_j) and the jth observation has Z = min(Z_i, Z_j). A p-matrix
can be made using the make.pmatrix function.}

\item{xi}{a number in the range 0 to 0.5, the cutoff related to the treatment
assignment probability caliper.}

\item{M}{an integer determining the penalty of the treatment assignment
probability caliper. If a potential matched pair between observations i and j
has treatment assignment probability less than xi or greater than 1-xi, add
M to the distance matrix in the (i, j) and (j, i) entry.}
}
\value{
I x 2 dataframe
}
\description{
This function creates a I x 2 dataframe containing the indices of observations
that form our set of matched pairs. It uses the nbpMatch package
\insertCite{lu2011optimal}{nbpInference} along with a p-matrix
in order to create I matched pairs using a treatment assignment caliper. A p-matrix
can be created using the \link[nbpInference]{make.pmatrix} function.
}
\examples{
set.seed(12345)
X <- rnorm(100, 0, 5)
Z <- X + rnorm(100, 0, (1+sqrt(abs(X))))
pmat <- make.pmatrix(Z, X)
nbp.caliper(Z, X, pmat, xi = 0.1, M = 10000)
}
\seealso{
Other inference: 
\code{\link{bias.corrected.neyman}()},
\code{\link{classic.neyman}()},
\code{\link{covAdj.variance}()},
\code{\link{make.pmatrix}()}
}
\concept{inference}
