% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_repos.R
\name{download_reg_repo}
\alias{download_reg_repo}
\title{Download and register git repository containing registrations}
\usage{
download_reg_repo(url, localdir = NULL, ...)
}
\arguments{
\item{url}{Location of one or more remote git repositories. Can accept
partial github specifications of the form "<user>/<repo>".}

\item{localdir}{Full path to local checkout location of git repository. When
\code{localdir=NULL}, the default, a sensible location is chosen using the
rappdirs function.}

\item{...}{additional arguments passed to \code{git2r::clone} e.g.
credentials for private repo.}
}
\value{
This function is principally called for its side effect. A path to
  the location on disk containing added registrations is returned invisibly.
}
\description{
Note that these extra registrations will be downloaded to a standard location
on your hard drive that will be used for one session to the next. See
examples and \code{\link{local_reg_dir_for_url}}.
}
\examples{
## find the root location of all registration directories
local_reg_dir_for_url()
\dontrun{
## Add the two main jefferislab bridging and mirroring registration
# collections for Drosophila brains from github.com.
download_reg_repo("jefferislab/BridgingRegistrations")
download_reg_repo("jefferislab/MirrorRegistrations")

## update all current registration repositories
update_reg_repos()
}
}
\seealso{
\code{\link{add_reg_folders}}, \code{\link{local_reg_dir_for_url}},
  \code{git2r::\link[git2r]{clone}}

\code{\link{update_reg_repos}}
}
