% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mxsem_group_by.R
\name{get_groups}
\alias{get_groups}
\title{get_groups}
\usage{
get_groups(multi_group_model)
}
\arguments{
\item{multi_group_model}{multi group model created with mxsem_group_by}
}
\value{
list with data for each group
}
\description{
returns a list of groups for a multi group model
}
\examples{
# THE FOLLOWING EXAMPLE IS ADAPTED FROM
# https://openmx.ssri.psu.edu/docs/OpenMx/latest/_static/Rdoc/mxModel.html
library(mxsem)

model <- 'spatial =~ visual + cubes + paper
          verbal  =~ general + paragrap + sentence
          math    =~ numeric + series + arithmet'

mg_model <- mxsem(model = model,
                  data  = OpenMx::HS.ability.data) |>
  # we want separate models for all combinations of grades and schools:
  mxsem_group_by(grouping_variables = "school") |>
  mxTryHard()

# let's summarize the results:
summarize_multi_group_model(mg_model)

# let's get the groups:
get_groups(mg_model)
}
