\name{pheno}
\alias{pheno}
\docType{data}
\title{
Phenotypic Risk Profiles of Toddlers
}
\description{
The \code{pheno} data frame has 1570 rows and 12 columns. Each row contains data from one toddler, which consists of multiple parent-report measures aimed at early identification of phenotypes at-risk for neurodevelopmental disorders such as autism. The data were originally analyzed by Doyle et al. (2021).
}
\usage{data("pheno")}
\format{
  A data frame with observations on the following 12 variables.
  \describe{
    \item{\code{age}}{a numeric vector representing the child's age in months. Ranges from 17 to 26 months.}
    \item{\code{sex}}{a factor vector representing the child's assigned sex at birth.}
    \item{\code{RM}}{an integer vector representing the child's repetitive movement score. Ranges from 0 to 36.}
    \item{\code{SDSI}}{an integer vector representing the child's self-directed/self-injurious score. Ranges from 0 to 22.}
    \item{\code{RR}}{an integer vector representing the child's ritual and routine score. Ranges from 0 to 28.}
    \item{\code{RI}}{an integer vector representing the child's restricted interests score. Ranges 0 to 35.}
    \item{\code{WP}}{an integer vector representing the child's  number of words-produced score. Ranges from 0 to 396.}
    \item{\code{TG}}{an integer vector representing the child's total number of gestures used. Ranges from 0 to 63.}
    \item{\code{RSB}}{an integer vector representing the child's reciprocal social behavior score. Ranges from 3 to 65.}
    \item{\code{Ext}}{an integer vector representing the child's externalizing behavior score. Ranges from 0 to 24. Only availabe for subsample of 107 toddlers.}
    \item{\code{Int}}{an integer vector representing the child's internalizing behavior score. Ranges from 4 to 33. Only availabe for subsample of 107 toddlers.}
    \item{\code{Dys}}{an integer vector representing the child's dysregulation behavior score. Ranges from 3 to 43. Only availabe for subsample of 107 toddlers.}
  }
}
\details{
These data consist of parents' responses to questionnaires concerning their toddler's behavior. The \code{RM}, \code{SDSI}, \code{RR}, and \code{RI} scores were obtained using the Repetitive Behavior Scale for Early Childhood (RBS-EC; Wolff et al., 2016). The \code{RSB} score was obtained using the Video-Referenced Rating of Reciprocal Social Behavior scale (vrRSB; Marrus et al., 2015). \code{WP} and \code{TG} scores were obtained via the MacArthur-Bates Communicative Developmental Inventories (MCDI: Fenson et al., 2007). Scores for \code{Ext}, \code{Int}, and \code{Dys} were obtained via the Infant Toddler Social Emotional Assessment (ITSEA; Carter et al., 2003).
For a detailed description of these data see Doyle et al. (2021).
}
\source{
Doyle, C.M., Lasch, C., Vollman, E.P., Desjardins, C.D., Helwig, N.E., Jacob, S., Wolff, J.J. and Elison, J.T. (2021), Phenoscreening: a developmental approach to research domain criteria-motivated sampling. Journal of Child Psychology and Psychiatry, 62: 884-894. \doi{10.1111/jcpp.13341}
}
\references{
Carter, A. S., Briggs-Gowan, M. J., Jones, S. M., & Little, T. D. (2003). The Infant-Toddler Social and Emotional Assessment (ITSEA): Factor structure, reliability, and validity. Journal of Abnormal Child Psychology, 31(5), 495–514. \doi{10.1023/A:1025449031360}

%Delgado, J. E., Elison, J. T., & Helwig, N. E. (2025). Robust Detection of Signed Outliers in Multivariate Data With Applications to
%Early Identification of Risk for Autism. Psychological Methods. (conditionally accepted)

Fenson, L., Bates, E., Dale, P.S., Marchman, V.A., Reznick,J.S., & Thal, D. (2007). MacArthur-Bates communicative development inventories user's guide and technical manual (2nd ed.). Baltimore, MD: Paul H. Brookes Publishing Company.

Marrus, N., Glowinski, A. L., Jacob, T., Klin, A., Jones, W., Drain, C. E., Holzhauer, K. E., Hariprasad, V., Fitzgerald, R. T., Mortenson, E. L., Sant, S. M., Cole, L., Siegel, S. A., Zhang, Y., Agrawal, A., Heath, A. C., & Constantino, J. N. (2015). Rapid video-referenced ratings of reciprocal social behavior in toddlers: a twin study. Journal of child psychology and psychiatry, and allied disciplines, 56(12), 1338–1346. \doi{10.1111/jcpp.12391}

Wolff, J. J., Boyd, B. A., & Elison, J. T. (2016). A quantitative measure of restricted and repetitive behaviors for early childhood. Journal of Neurodevelopmental Disorders, 8(1), 27–27. \doi{10.1186/s11689-016-9161-x}
}

\examples{
# load data
library(mvout)
data(pheno)
X <- pheno[,3:9]

# method = "princomp" and direction = "two-sided"
set.seed(1)    # for reproducible MCD estimate
pc2sided <- mvout(X, method = "princomp", rotation = "promax")
plot(pc2sided)

# method = "princomp" and directional
dir <- c(rep("greater", 4), rep("less", 2), "greater")
set.seed(1)    # for reproducible MCD estimate
pc1sided <- mvout(X, method = "princomp", rotation = "promax", direction = dir)
plot(pc1sided)

# method = "factanal" and direction = "two.sided"
set.seed(1)    # for reproducible MCD estimate
fa2sided <- mvout(X, method = "factanal", rotation = "promax")
plot(fa2sided)

# method = "factanal" and directional
dir <- c(rep("greater", 4), rep("less", 2), "greater")
set.seed(1)    # for reproducible MCD estimate
fa1sided <- mvout(X, method = "factanal", rotation = "promax", direction = dir)
plot(fa1sided)
}

\keyword{ datasets }
