% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ase}
\alias{ase}
\title{Adjacency Spectral Embedding (ASE)}
\usage{
ase(M,d)
}
\arguments{
\item{M}{A symmetric matrix.}

\item{d}{A non-negative integer embedding dimension.}
}
\value{
An \eqn{n \times d} matrix \eqn{X}, defined as \eqn{U |S|^{1/2}}
where \eqn{S} is a diagonal matrix of the \eqn{d} leading (in absolute value)
eigenvalues of \eqn{M}, and \eqn{U} is a matrix of the corresponding
eigenvectors.

\eqn{X} has an additional attribute \code{"signs"} which gives the sign of
the eigenvalue corresponding to each column.

If \eqn{d=0}, \code{ase} returns an \eqn{n \times 1}
matrix of zeros.
}
\description{
\code{ase} calculates the \eqn{d}-dimensional adjacency spectral embedding of a symmetric
\eqn{n \times n} matrix \eqn{M}.
}
