% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mwi.R
\name{mwi}
\alias{mwi}
\title{Multimorbidity Weighted Index (MWI)}
\usage{
mwi(dat = NULL, id = NULL, dx = "dx", version = 19, version_var = NULL)
}
\arguments{
\item{dat}{dataset which has been properly prepared using 'prepare_data()'}

\item{id}{variable of the unique patient identifier}

\item{dx}{the column with the diagnoses and procedures (defaults to 'dx')}

\item{version}{which version(s) of ICD your data contain (ICD-9 only: 9, ICD-10 only: 10,
Both: 19)}

\item{version_var}{variable which denotes if the diagnoses on that row are ICD-9 (9) or
ICD-10 (10)}
}
\description{
\code{cfi} returns a summary dataset containing the multimorbidity weighted index
for each patient.
}
\details{
This function uses data which has been properly prepared to calculate the multimorbidity weighted index developed by Wei et al.
As this algorithm was never developed to require two diagnosis codes, and is weighted, we have excluded that feature from this function.
See full package documentation for additional details.
}
\examples{
mwi(dat = prepared_data, id = patient_id, dx = dx, version = 9, version_var = version)


}
