% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twins_data.R
\docType{data}
\name{twins_data}
\alias{twins_data}
\title{A set of fetal movements data in twins.}
\format{
An object of class \code{"data.frame"}
\describe{
 \item{id}{The fetus from the same twins share the same id number.}
 \item{SelfTouchCodable}{frequency of self-touch for each fetus.}
 \item{OtherTouchCodable}{frequency of twin-to-twin for each fetus.}
 \item{Depression}{Depression scale of the mothers.}
 \item{PSS}{Perceived Stress Scale of the mothers.}
 \item{Anxiety}{Hospital Anxiety of the mothers.}
}
}
\usage{
data(twins_data)
}
\description{
This data was collected for research on the effects of maternal mental health on prenatal movements in twins and singletons (Reissland et al., 2021).
There are two touch movement types of the fetus recorded: self-touch and twin-to-twin touch,
and the mothers’ mental health status was collected on three variables: depression, perceived stress scale and stress.
There are 14 pairs of twins, 11 of the mothers were available for one scan and 3 of them were available for two scans,
i.e. in total there are 34 observations. This dataset contains only the twins data from the original study.
}
\examples{

data(twins_data)
head(twins_data)
}
\references{
Reissland, N., Einbeck, J., Wood, R., and Lane, A. (2021).
            Effects of maternal mental health on prenatal movement profiles in twins and singletons.
            Acta Paediatrica, 110(9):2553–2558.
}
\keyword{datasets}
