% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical.R
\name{sample_gap_splice}
\alias{sample_gap_splice}
\title{Randomly create matching segments from a splicing table without overlaps}
\usage{
sample_gap_splice(splicing_dfr, v, num_splices, rejection_list = list())
}
\arguments{
\item{splicing_dfr}{\code{Splice} object.}

\item{v}{\code{View} object.}

\item{num_splices}{number of random splices to generate.}

\item{rejection_list}{list of \code{Splice} objects for rejection.}
}
\value{
list of splicing data.frames.
}
\description{
Works by randomly varying the gaps between segments assuming that the gap number
follow a Poisson process with rate given by the average sample gap length in
the input splice. Durations of segments remain the same.
}
\details{
Uses rejection sampling to avoid overlaps with the input segments and
additional segments from a list of splices.
}
\examples{
r1 <- get_sample_recording()
d1 <- get_duration_annotation_data(r1)
rv1 <- get_raw_view(r1, "Central", "", "Sitar")
splicing_df <- splice_time(d1, tier ='INTERACTION', comments = 'Mutual look and smile')
# Only first segment relevant for sample data
x <- sample_gap_splice(splicing_df[1,], rv1, num_splices = 10)
}
\seealso{
Other statistical and analysis functions: 
\code{\link{apply_column_spliceview}()},
\code{\link{apply_segment_spliceview}()},
\code{\link{ave_cross_power_over_splices}()},
\code{\link{ave_cross_power_spliceview}()},
\code{\link{ave_power_over_splices}()},
\code{\link{ave_power_spliceview}()},
\code{\link{calculate_ave_cross_power1}()},
\code{\link{calculate_ave_power1}()},
\code{\link{compare_ave_cross_power1}()},
\code{\link{compare_ave_power1}()},
\code{\link{compare_avg_cross_power2}()},
\code{\link{compare_avg_power2}()},
\code{\link{difference_onsets}()},
\code{\link{pull_segment_spliceview}()},
\code{\link{sample_offset_splice}()},
\code{\link{summary_onsets}()},
\code{\link{visualise_sample_splices}()}
}
\concept{statistical and analysis functions}
