% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/granger.R
\name{granger_test}
\alias{granger_test}
\title{Granger causality tests applied to a SplicedView}
\usage{
granger_test(
  obj,
  var1,
  var2,
  var3 = "",
  lag = 1,
  granger_fn = ms_grangertest2,
  cond_granger_fn = ms_condgrangertest
)
}
\arguments{
\item{obj}{SplicedView object}

\item{var1}{column name of response}

\item{var2}{column name of predictor}

\item{var3}{column name of conditioning}

\item{lag}{in seconds (rounded to nearest frame)}

\item{granger_fn}{function to perform Granger test (defaults to ms_grangertest2)}

\item{cond_granger_fn}{function to perform conditional Granger test (defaults to ms_condgrangertest)}
}
\value{
GrangerTime object
}
\description{
Granger causality tests applied to a SplicedView
}
\examples{

r1 <- get_sample_recording()
rv_list <- get_raw_views(r1)
pv_list <- lapply(rv_list, get_processed_view)
get_data_points(pv_list$Central_Sitar)
fv_list <- lapply(pv_list, apply_filter_sgolay, data_points = "Nose", n = 41, p = 3)
jv_sub <- get_joined_view(fv_list)
splicing_df <- splice_time(jv_sub, win_size = 5, step_size = 0.5)
sv <- get_spliced_view(jv_sub, splicing_df)
granger_test(sv, "Nose_x_Central_Sitar", "Nose_x_Central_Tabla", lag = 1/25)
granger_test(sv, "Nose_x_Central_Sitar", "Nose_x_Central_Tabla", "Nose_y_Central_Tabla", lag = 1/25)
}
\seealso{
Other Granger Causality: 
\code{\link{autoplot.GrangerTime}()},
\code{\link{get_granger_interactions}()},
\code{\link{map_to_granger_test}()},
\code{\link{ms_condgrangertest}()},
\code{\link{ms_grangertest1}()},
\code{\link{ms_grangertest2}()},
\code{\link{plot.GrangerInteraction}()},
\code{\link{plot_influence_diagram}()}
}
\concept{Granger Causality}
