% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical.R
\name{ave_cross_power_over_splices}
\alias{ave_cross_power_over_splices}
\title{Calculate mean average cross power over splices using a splicing table}
\usage{
ave_cross_power_over_splices(
  jv,
  splicing_df,
  num_splices,
  columns,
  sampling_type = "offset",
  rejection_list = list(),
  include_original = TRUE,
  show_plot = TRUE
)
}
\arguments{
\item{jv}{\code{JoinedView} object.}

\item{splicing_df}{\code{Splice} object.}

\item{num_splices}{number of randomly chosen splices.}

\item{columns}{name of data columns on which to calculate average cross power.}

\item{sampling_type}{either 'offset' or 'gap'.}

\item{rejection_list}{list of splice objects that random splices must not overlap.}

\item{include_original}{include the original splice in output? (Default is TRUE).}

\item{show_plot}{show a plot? (Default is TRUE).}
}
\value{
data.frame of splice segments and their average cross power.
}
\description{
Randomly generates splices from a splicing table and calculates average
cross power for each segment and splice. Calculates the mean average cross power
over the random splices for each segment and period. Compares with the
average cross power for the original splice.
}
\examples{
r <- get_sample_recording()
fv_list <- get_filtered_views(r, data_points = "Nose", n = 41, p = 3)
jv <- get_joined_view(fv_list)

d <- get_duration_annotation_data(r)
splicing_tabla_solo_df <- splice_time(d,
  expr = "Tier == 'INTERACTION' & Comments == 'Mutual look and smile'")

# Only do the first splice for sample data
mean_ave_cross_power_df <- ave_cross_power_over_splices(jv,
  splicing_tabla_solo_df[1,], num_splices = 10,
  columns = c('Nose_x_Central_Sitar', 'Nose_y_Central_Sitar'), show_plot = TRUE)
}
\seealso{
Other statistical and analysis functions: 
\code{\link{apply_column_spliceview}()},
\code{\link{apply_segment_spliceview}()},
\code{\link{ave_cross_power_spliceview}()},
\code{\link{ave_power_over_splices}()},
\code{\link{ave_power_spliceview}()},
\code{\link{calculate_ave_cross_power1}()},
\code{\link{calculate_ave_power1}()},
\code{\link{compare_ave_cross_power1}()},
\code{\link{compare_ave_power1}()},
\code{\link{compare_avg_cross_power2}()},
\code{\link{compare_avg_power2}()},
\code{\link{difference_onsets}()},
\code{\link{pull_segment_spliceview}()},
\code{\link{sample_gap_splice}()},
\code{\link{sample_offset_splice}()},
\code{\link{summary_onsets}()},
\code{\link{visualise_sample_splices}()}
}
\concept{statistical and analysis functions}
