test_that("Nsurv", {
    # LONG TO COMPUTE AND/OR INPUT FILE NOT STORED FOR CRAN
    # 'skip_on_cran: files not in fixtures because of size > 1MB'
    testthat::skip_on_cran()
    cPRZ_ITfit <- readRDS(test_path("fixtures", "cPRZ_ITfit.rds"))
    cPRZ_SDfit <- readRDS(test_path("fixtures", "cPRZ_SDfit.rds"))
    vPRZ_ITfit <- readRDS(test_path("fixtures", "vPRZ_ITfit.rds"))
    vPRZ_SDfit <- readRDS(test_path("fixtures", "vPRZ_SDfit.rds"))
    
    data_4prediction <- data.frame(time = c(1:10, 1:10),
                                   conc = c(c(0,0,40,0,0,0,40,0,0,0),
                                            c(21,19,18,23,20,14,25,8,13,5)),
                                   replicate = c(rep("pulse", 10), rep("random", 10)))
    
    # Prediction
    new_predict_cstSD <- predict(fit_cstSD, data_4prediction)
    new_predict_cstIT <- predict(fit_cstIT, data_4prediction)
    
    expect_no_error({
        compute_Nsurv(new_predict_cstSD, 10)
        compute_Nsurv(new_predict_cstIT, 10)
    })
    
})
