test_that("priors", {
    # LONG TO COMPUTE AND/OR INPUT FILE NOT STORED FOR CRAN
    # 'skip_on_cran: files not in fixtures because of size > 1MB'
    testthat::skip_on_cran()
    cPRZ_ITfit <- readRDS(test_path("fixtures", "cPRZ_ITfit.rds"))
    cPRZ_SDfit <- readRDS(test_path("fixtures", "cPRZ_SDfit.rds"))
    vPRZ_ITfit <- readRDS(test_path("fixtures", "vPRZ_ITfit.rds"))
    vPRZ_SDfit <- readRDS(test_path("fixtures", "vPRZ_SDfit.rds"))
    
    expect_no_error({
        priors_distribution(cPRZ_ITfit)
        priors_distribution(cPRZ_SDfit)
        priors_distribution(vPRZ_ITfit)
        priors_distribution(vPRZ_SDfit)
    })
    
})

test_that("priorPosterior", {
    # LONG TO COMPUTE AND/OR INPUT FILE NOT STORED FOR CRAN
    # 'skip_on_cran: files not in fixtures because of size > 1MB'
    testthat::skip_on_cran()
    cPRZ_ITfit <- readRDS(test_path("fixtures", "cPRZ_ITfit.rds"))
    cPRZ_SDfit <- readRDS(test_path("fixtures", "cPRZ_SDfit.rds"))
    vPRZ_ITfit <- readRDS(test_path("fixtures", "vPRZ_ITfit.rds"))
    vPRZ_SDfit <- readRDS(test_path("fixtures", "vPRZ_SDfit.rds"))
    
    expect_no_error({
        cPRZ_ITpp <- priorPosterior(cPRZ_ITfit)
        cPRZ_SDpp <- priorPosterior(cPRZ_SDfit)
        vPRZ_ITpp <- priorPosterior(vPRZ_ITfit)
        vPRZ_SDpp <- priorPosterior(vPRZ_SDfit)
    })
    
    expect_no_error({
        plot(cPRZ_ITpp)
        plot(cPRZ_SDpp)
        plot(vPRZ_ITpp)
        plot(vPRZ_SDpp)
    })

})
