% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-SurvData.R, R/plot-SurvFit.R
\name{SurvFit}
\alias{SurvFit}
\alias{fit}
\alias{fit.SurvDataCstExp}
\alias{fit.SurvDataVarExp}
\alias{plot.SurvFit}
\title{Fits a TKTD model for survival analysis using Bayesian inference}
\usage{
fit(data, model_type, hb_value, ...)

\method{fit}{SurvDataCstExp}(data, model_type, hb_value = NULL, ...)

\method{fit}{SurvDataVarExp}(data, model_type, hb_value = NULL, ...)

\method{plot}{SurvFit}(
  x,
  xlab = "Time",
  ylab = "Number of Survival",
  main = NULL,
  add_data = TRUE,
  add_legend = FALSE,
  ...
)
}
\arguments{
\item{data}{An object of class \code{survDataCstExp} or \code{survDataVarExp}.}

\item{model_type}{Can be \code{"SD"} or \code{"IT"} to choose
between "Stochastic Death" or "Individual Tolerance" models
(resp.). See the modeling vignette for details.}

\item{hb_value}{If \code{TRUE}, the background mortality \code{hb} is taken into account.
If \code{FALSE}, parameter \code{hb} is set to 0. The default is \code{TRUE}.}

\item{\dots}{Further arguments to be passed to generic methods
using argument of \link[rstan]{sampling} function.}

\item{x}{a \code{\link{SurvFit}} object}

\item{xlab}{label of the x-axis, default is "Time",}

\item{ylab}{label of the y-axis, default is "Number of Survival"}

\item{main}{title of the plot, defaul is \code{NULL},}

\item{add_data}{to add original data to the plot. Default ir \code{TRUE}}

\item{add_legend}{add legend to the plot, default is \code{FALSE}}
}
\value{
An object of class \code{stanfit} returned by \code{rstan::sampling}

an object of class \code{ggplot}, see function \code{\link[ggplot2]{ggplot}}
}
\description{
This function estimates the parameters of a TKTD model ('SD' or 'IT')
for survival analysis using Bayesian inference. In this model,
the survival rate of individuals is modeled as a function of the chemical compound
concentration with a mechanistic description of the effects on survival over
time.

The function returns the parameter estimates of
Toxicokinetic-toxicodynamic (TKTD) models
\code{SD} for 'Stochastic Death' or \code{IT} fo 'Individual Tolerance'.
TKTD models, and particularly the General Unified Threshold model of
Survival (GUTS), provide a consistent process-based
framework to analyse both time and concentration dependent datasets.
In GUTS-SD, all organisms are assumed to have the same internal concentration
threshold (denoted \eqn{z}), and, once exceeded, the instantaneous probability
to die increases linearly with the internal concentration.
In GUTS-IT, the threshold concentration is distributed among all the organisms, and once
exceeded in one individual, this individual dies immediately.

This is the generic \code{plot} S3 method for the \code{SurvFit} class. It
plots concentration-response fit under target time survival analysis.
}
\references{
Jager, T., Albert, C., Preuss, T. G. and Ashauer, R. (2011)
General unified threshold model of survival-a toxicokinetic-toxicodynamic
framework for ecotoxicology, \emph{Environmental Science and Technology}, 45, 2529-2540.
303-314.
}
\keyword{estimation}
\keyword{plot}
