% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-ModelData.R
\name{ModelData}
\alias{ModelData}
\alias{modelData}
\alias{modelData.SurvData}
\alias{build_stanData}
\alias{build_priors}
\title{Create a list giving data to use in Bayesian inference.}
\usage{
modelData(data, model_type, ...)

\method{modelData}{SurvData}(data, model_type = c("SD", "IT"), hb_value = NULL, ...)

build_stanData(x)

build_priors(x, model_type = c("SD", "IT"), hb_value = NULL)
}
\arguments{
\item{data}{An object of class \code{SurvData}}

\item{model_type}{TKTD model type ('SD' or 'IT')}

\item{\dots}{Further arguments to be passed to generic methods}

\item{hb_value}{default is NULL, can be fixed by specifying a numeric.}

\item{x}{An object of class \code{survData}}
}
\value{
A list for parameterization of priors for Bayesian inference.

A list for parameterization of priors for Bayesian inference with JAGS.
}
\description{
Function to build the data list to give to stan

\enumerate{
\item Order the data set in replicate and then in time to create a new column
\code{i_row} used to delimited replicates.
\item Create a matrix of replicate and index "id_row"
\item Compute Nprec = lag of Nsurv
\item return a list of element to be passed to Stan sampler
}

Create a list of scalars giving priors to use in Bayesian inference.
}
