#' @name cadmium1
#'
#' @title Reproduction and survival data sets of chronic laboratory toxicity
#' tests of cadmium with Daphnia
#'
#' @description
#' - **cadmium1**: Reproduction and survival data sets of chronic laboratory toxicity tests with
#' \emph{Daphnia magna} freshwater invertebrate exposed to five concentrations
#' of cadmium during 21 days. Five concentrations were
#' tested, with four replicates per concentration. Each replicate contained 10
#' organisms. Reproduction and survival were monitored at 10 time points.
#'
#' @references
#' Billoir, E., Delhaye, H., Forfait, C., Clement, B.,
#' Triffault-Bouchet, G., Charles, S. and Delignette-Muller, M.L. (2012)
#' Comparison of toxicity tests with different exposure time patterns: The added
#' value of dynamic modelling in predictive ecotoxicology, \emph{Ecotoxicology
#' and Environmental Safety}, 75, 80-86.
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @usage
#' data(cadmium1)
#'
NULL

#' @name cadmium2
#'
#' @title Reproduction and survival data sets of chronic laboratory toxicity
#' tests of cadmium with snails
#'
#' @description
#' - **cadmium2**: Reproduction and survival data sets of chronic laboratory toxicity tests with
#' snails (\emph{Lymnaea stagnalis}) exposed to six concentrations of cadmium
#' during 28 days. Six concentrations were tested, with six replicates per
#' concentration. Each replicate contained five organisms. Reproduction and
#' survival were monitored at 17 time points.
#'
#' @references
#' Ducrot, V., Askem, C., Azam, D., Brettschneider, D., Brown,
#' R., Charles, S., Coke, M., Collinet, M., Delignette-Muller, M.L.,
#' Forfait-Dubuc, C., Holbech, H., Hutchinson, T., Jach, A., Kinnberg, K.L.,
#' Lacoste, C., Le Page, G., Matthiessen, P., Oehlmann, J., Rice, L.,
#' Roberts, E., Ruppert, K., Davis, J.E., Veauvy, C., Weltje, L., Wortham, R.
#' and Lagadic, L. (2014)
#' Development and validation of an OECD reproductive toxicity test guideline with
#' the pond snail Lymnaea stagnalis (Mollusca, Gastropoda),
#' \emph{Regulatory Toxicology and Pharmacology}, 70(3), 605-14.
#'
#' Charles, S., Ducrot, V., Azam, D., Benstead, R., Brettschneider, D., De Schamphelaere, K.,
#' Filipe Goncalves, S., Green, J.W., Holbech, H., Hutchinson, T.H., Faber, D., Laranjeiro, F.,
#' Matthiessen, P., Norrgren, L., Oehlmann, J., Reategui-Zirena, E., Seeland-Fremer, A., Teigeler, M.,
#' Thome, J.P., Tobor Kaplon, M., Weltje, L., Lagadic, L. (2016)
#' Optimizing the design of a reproduction toxicity test with the pond snail Lymnaea stagnalis,
#' \emph{Regulatory Toxicology and Pharmacology}, vol. 81 pp.47-56.
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @usage
#' data(cadmium2)
#'
NULL

#' @name chlordan
#'
#' @title Reproduction and survival data sets of chronic laboratory toxicity
#'  tests of chlordan with Daphnia
#'
#' @description
#' - **chlordan**: Reproduction and survival data sets of chronic laboratory toxicity tests with
#' \emph{Daphnia magna} freshwater invertebrate exposed to six concentrations
#' of one organochlorine insecticide (chlordan) during 21 days. Six concentrations were
#' tested, with 10 replicates per concentration. Each replicate contained one
#' organism. Reproduction and survival were monitored at 22 time points.
#' See Manar et al. (2009).
#'
#' @references
#' Manar, R., Bessi, H. and Vasseur, P. (2009) Reproductive effects
#' and bioaccumulation of chlordan in Daphnia magna, \emph{Environmental
#' Toxicology and Chemistry}, 28(10), 2150-2159.
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @usage
#' data(chlordan)
#'
NULL


#' @name copper
#'
#' @title Reproduction and survival data sets of chronic laboratory toxicity
#' tests of copper on Daphnia
#'
#' @description
#' - **copper**: Reproduction and survival data sets of chronic laboratory toxicity tests with
#' \emph{Daphnia magna} freshwater invertebrate exposed to five concentrations
#' of copper during 21 days. Five concentrations were
#' tested, with three replicates per concentration. Each replicate contained 20
#' organisms. Reproduction and survival were monitored at 16 time points.
#'
#' @references Billoir, E., Delignette-Muller, M.L., Pery, A.R.R. and
#' Charles, S. (2008) A Bayesian Approach to Analyzing Ecotoxicological Data,
#' \emph{Environmental Science & Technology}, 42 (23), 8978-8984.
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @usage
#' data(copper)
#'
NULL

#' @name dichromate
#'
#' @title Survival data set of chronic laboratory toxicity tests of dichromate
#' with Daphnia
#'
#' @description
#' - **dichromate**: Survival data set of chronic laboratory toxicity tests with
#' \emph{Daphnia magna} freshwater invertebrate exposed to six concentrations
#' of one oxidizing agent (potassium dichromate) during 21 days. Six
#' concentrations were tested with one replicate of 50 organisms per concentration.
#' Survival is monitored at 10 time points.
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @references Bedaux, J., Kooijman, SALM (1994) Statistical analysis of toxicity tests,
#' based on hazard modeling, \emph{Environmental and Ecological Statistics}, 1,
#' 303-314.
#'
#' @usage
#' data(dichromate)
#'
NULL

#' @name propiconazole
#'
#' @title Survival data set of chronic laboratory toxicity tests of propiconazole
#' with Gammarus pulex
#'
#' @description
#' - **propiconazole**: Survival data set of chronic laboratory toxicity tests with
#' \emph{Gammarus pulex} freshwater invertebrate exposed to eight concentrations
#' of one fungicide (propiconazole) during four days. Eight
#' concentrations were tested with two replicates of 10 organisms per concentration.
#' Survival is monitored at five time points.
#'
#' @references Nyman, A.-M., Schirmer, K., Ashauer, R., (2012) Toxicokinetic-toxicodynamic
#' modelling of survival of \emph{Gammarus pulex} in multiple pulse exposures to
#' propiconazole: model assumptions, calibration data requirements and predictive
#' power, \emph{Ecotoxicology}, (21), 1828-1840.
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @usage
#' data(propiconazole)
#'
#'
NULL

#' @name propiconazole_pulse_exposure
#'
#' @title Survival data set of chronic laboratory toxicity tests of propiconazole
#' with Gammarus pulex
#'
#' @description
#' - **propiconazole_pulse_exposure**: Survival data set for 
#' \emph{Gammarus pulex} exposed to propiconazole
#' during 10 days with time-variable
#' exposure concentration (non-standard pulsed toxicity experiments).
#' Survival data set of laboratory toxicity tests with \emph{Gammarus pulex}
#' freshwater invertebrates exposed to several profiles of concentrations
#' (time-variable concentration for each time series)
#' of one fungicide (propiconazole) during 10 days.
#'
#' @references Nyman, A.-M., Schirmer, K., Ashauer, R., (2012) Toxicokinetic-toxicodynamic
#' modelling of survival of \emph{Gammarus pulex} in multiple pulse exposures to
#' propiconazole: model assumptions, calibration data requirements and predictive
#' power, \emph{Ecotoxicology}, (21), 1828-1840.
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @usage
#' data(propiconazole_pulse_exposure)
#'
#'
NULL

#' @name zinc
#'
#' @title Reproduction and survival data sets of a chronic laboratory toxicity
#'  tests of zinc with Daphnia
#'
#' @description
#' - **zinc**: Reproduction and survival data sets of a chronic laboratory toxicity tests with
#' \emph{Daphnia magna} freshwater invertebrate exposed to four concentrations
#' of zinc during 21 days. Four concentrations were
#' tested with three replicates per concentration. Each replicate contained 20
#' organisms. Reproduction and survival were monitored at 15 time points.
#'
#' @references Billoir, E., Delignette-Muller, M.L., Pery, A.R.R. and
#' Charles, S. (2008) A Bayesian Approach to Analyzing Ecotoxicological Data,
#' \emph{Environmental Science & Technology}, 42 (23), 8978-8984.
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @usage
#' data(zinc)
#'
NULL


#' @name FOCUSprofile
#'
#' @title A simulated exposure profile with 11641 time points using FOCUS model.
#'
#' @description
#' - **FOCUSprofile**: A simulated exposure profile with 11641 time points.
#' Exposure profile of 11641 time points used for prediction.
#' A data frame with 11641 observations on the following two variables:
#' \code{time}, a vector of class \code{numeric}, \code{conc}, a vector
#'  of class \code{numeric} with exposure concentrations, and
#'  \code{replicate}, a vector of class \code{factor}. 
#'
#' @docType data
#'
#' @keywords datasets
#'
#' @usage
#' data(FOCUSprofile)
#'
NULL