% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.R
\name{hmftest}
\alias{hmftest}
\alias{hmftest.formula}
\alias{hmftest.mlogit}
\title{Hausman-McFadden Test}
\usage{
hmftest(x, ...)

\method{hmftest}{formula}(x, alt.subset, ...)

\method{hmftest}{mlogit}(x, z, ...)
}
\arguments{
\item{x}{an object of class `mlogit` or a formula,}

\item{...}{further arguments passed to `mlogit` for the `formula`
method.}

\item{alt.subset}{a subset of alternatives,}

\item{z}{an object of class `mlogit` or a subset of alternatives
for the `mlogit` method. This should be the same model as `x`
estimated on a subset of alternatives,}
}
\value{
an object of class `"htest"`.
}
\description{
Test the IIA hypothesis (independence of irrelevant alternatives)
for a multinomial logit model.
}
\details{
This is an implementation of the Hausman's consistency test for
multinomial logit models. If the independance of irrelevant
alternatives applies, the probability ratio of every two
alternatives depends only on the characteristics of these
alternatives. Consequentely, the results obtained on the estimation
with all the alternatives or only on a subset of them are
consistent, but more efficient in the first case. On the contrary,
only the results obtained from the estimation on a relevant subset
are consistent. To compute this test, one needs a model estimated
with all the alternatives and one model estimated on a subset of
alternatives. This can be done by providing two objects of class
`mlogit`, one object of class `mlogit` and a character vector
indicating the subset of alternatives, or a formula and a subset of
alternatives.
}
\examples{

## from Greene's Econometric Analysis p. 731

data("TravelMode", package = "AER")
TravelMode <- mlogit.data(TravelMode, choice = "choice", shape = "long",
                          alt.var = "mode", chid.var = "individual",
                          drop.index = FALSE)

## Create a variable of income only for the air mode

TravelMode$avinc <- with(TravelMode, (mode == 'air') * income)

## Estimate the model on all alternatives, with car as the base level
## like in Greene's book.

x <- mlogit(choice ~ wait + gcost + avinc, TravelMode, reflevel = "car")

## Estimate the same model for ground modes only (the variable avinc
## must be dropped because it is 0 for every observation

g <- mlogit(choice ~ wait + gcost, TravelMode, reflevel = "car",
            alt.subset = c("car", "bus", "train"))

## Compute the test

hmftest(x,g)
}
\references{
Hausman, J.A. and D. McFadden (1984), A Specification Test for the
Multinomial Logit Model, *Econometrica*, **52**, pp.1219--1240.
}
\author{
Yves Croissant
}
\keyword{htest}
