% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpar.R
\name{distribution}
\alias{distribution}
\alias{stdev}
\alias{med}
\alias{rg}
\alias{mean.rpar}
\alias{med.rpar}
\alias{stdev.rpar}
\alias{rg.mlogit}
\alias{mean.mlogit}
\alias{med.mlogit}
\alias{stdev.mlogit}
\alias{rg.rpar}
\alias{qrpar}
\alias{prpar}
\alias{drpar}
\alias{qrpar.rpar}
\alias{prpar.rpar}
\alias{drpar.rpar}
\alias{qrpar.mlogit}
\alias{prpar.mlogit}
\alias{drpar.mlogit}
\title{Functions used to describe the characteristics of estimated random
parameters}
\usage{
stdev(x, ...)

rg(x, ...)

med(x, ...)

\method{mean}{rpar}(x, norm = NULL, ...)

\method{med}{rpar}(x, norm = NULL, ...)

\method{stdev}{rpar}(x, norm = NULL, ...)

\method{rg}{rpar}(x, norm = NULL, ...)

\method{mean}{mlogit}(x, par = NULL, norm = NULL, ...)

\method{med}{mlogit}(x, par = NULL, norm = NULL, ...)

\method{stdev}{mlogit}(x, par = NULL, norm = NULL, ...)

\method{rg}{mlogit}(x, par = NULL, norm = NULL, ...)

qrpar(x, ...)

prpar(x, ...)

drpar(x, ...)

\method{qrpar}{rpar}(x, norm = NULL, ...)

\method{prpar}{rpar}(x, norm = NULL, ...)

\method{drpar}{rpar}(x, norm = NULL, ...)

\method{qrpar}{mlogit}(x, par = 1, y = NULL, norm = NULL, ...)

\method{prpar}{mlogit}(x, par = 1, y = NULL, norm = NULL, ...)

\method{drpar}{mlogit}(x, par = 1, y = NULL, norm = NULL, ...)
}
\arguments{
\item{x}{a `mlogit` or a `rpar` object,}

\item{...}{further arguments.}

\item{norm}{the variable used for normalization if any : for the
`mlogit` method, this should be the name of the parameter, for
the `rpar` method the absolute value of the parameter,}

\item{par}{the required parameter(s) for the `mlogit` methods
(either the name or the position of the parameter(s). If
`NULL`, all the random parameters are used.}

\item{y}{values for which the function has to be evaluated,}
}
\value{
a numeric vector for `qrpar`, `drpar` and `prpar`, a
    numeric vector for `mean`, `stdev` and `med` and a numeric
    matrix for `rg`.
}
\description{
Functions used to describe the characteristics of estimated random
parameters
}
\details{
`rpar` objects contain all the relevant information about
    the distribution of random parameters. These functions enables
    to obtain easily descriptive statistics, density, probability
    and quantiles of the distribution.

`mean`, `med`, `stdev` and `rg` compute respectively the mean, the
median, the standard deviation and the range of the random
parameter. `qrpar`, `prpar`, `drpar` return functions that compute
the quantiles, the probability and the density of the random
parameters (note that `sd` and `range` are not generic function in
`R` and that `median` is, but without `...`).
}
\seealso{
[mlogit()] for the estimation of random parameters logit
    models and [rpar()] for the description of `rpar` objects.
}
\author{
Yves Croissant
}
\keyword{regression}
