% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eta.R
\name{eta}
\alias{eta}
\title{Extracts the natural parameters from an estimated \code{mlergm} model. When the model is a canonical exponential family, this is the the identity mapping from the parameter vector. However, when the model is a curved exponential family this returns the resulting canonical parameters of the curved exponential family.}
\usage{
eta(object, block = NULL)
}
\arguments{
\item{object}{An object of class \code{mlergm}, probably produced by \code{\link{mlergm}}.}

\item{block}{Block identifier which should be an element of node_memb in the network.}
}
\description{
Extracts the natural parameters from an estimated \code{mlergm} model. When the model is a canonical exponential family, this is the the identity mapping from the parameter vector. However, when the model is a curved exponential family this returns the resulting canonical parameters of the curved exponential family.
}
\references{
Hunter, D. R., and Handcock, M. S. (2006).
Inference in curved exponential family models for networks.
Journal of Computational and Graphical Statistics, 15(3), 565-583.
}
