% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{clean_team_abbrs}
\alias{clean_team_abbrs}
\title{Standardize MLB Team Abbreviations}
\usage{
clean_team_abbrs(abbr, keep_non_matches = TRUE)
}
\arguments{
\item{abbr}{a character vector of abbreviations}

\item{keep_non_matches}{will non-matches be kept in the vector?}
}
\value{
A character vector with the length of \code{abbr} and cleaned team abbreviations
if they are included in \code{team_data}. Non matches may be replaced
with \code{NA} (depending on the value of \code{keep_non_matches}).
}
\description{
This function standardizes MLB team abbreviations to Baseball Savant defaults.
This helps for joins and plotting
}
\examples{
\donttest{
x <- c("PIE", "STL", "WSN", "CWS", "CHW")
# use current location and keep non matches
clean_team_abbrs(x)
}
}
