% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_error}
\alias{plot_error}
\title{Plot response error of behavioural data relative to target values.}
\usage{
plot_error(
  data,
  unit = "degrees",
  id_var = "id",
  response_var = "response",
  target_var = "target",
  set_size_var = NULL,
  condition_var = NULL,
  n_bins = 18,
  n_col = 2,
  return_data = FALSE,
  palette = "Dark2",
  scale_y_axis = NULL
)
}
\arguments{
\item{data}{A data frame with columns containing: participant identifier
('id_var'); the participants' response per trial ('response_var'); the
target value ('target_var'); and, if applicable, the set size of each
response ('set_size_var'), and the condition of each response
('condition_var').}

\item{unit}{The unit of measurement in the data frame: "degrees"
(measurement is in degrees, from 0 to 360); "degrees_180 (measurement is in
degrees, but limited to 0 to 180); or "radians" (measurement is in radians,
from pi to 2 * pi, but could also be already in -pi to pi).}

\item{id_var}{The column name coding for participant id. If the data is from
a single participant (i.e., there is no id column) set to "NULL".}

\item{response_var}{The column name coding for the participants' responses.}

\item{target_var}{The column name coding for the target value.}

\item{set_size_var}{The column name (if applicable) coding for the set
size of each response.}

\item{condition_var}{The column name (if applicable) coding for the
condition of each response.}

\item{n_bins}{An integer controlling the number of cells / bins used in the
plot.}

\item{n_col}{An integer controlling the number of columns in the resulting
plot.}

\item{return_data}{A boolean (TRUE or FALSE) indicating whether the data for
the plot should be returned.}

\item{palette}{A character stating the preferred colour palette to use. To
see all available palettes, type ?scale_colour_brewer into the console.}

\item{scale_y_axis}{A vector of 2 elements stating the minimum and maximum
value to use for the y-axis in the plots.}
}
\value{
If \code{return_data} is set to \code{FALSE} (which it is by default),
the function returns a ggplot2 object visualising the density distribution
of response error averaged across participants (if applicable) per set-size
(if applicable) and condition (if applicable).

If \code{return_data} is set to \code{TRUE}, the function returns a
list with two components:

 \itemize{
 \item \code{plot:} The ggplot2 object.
 \item \code{data:} A data frame with the data used to generate the plot.
 }
}
\description{
Function to plot the response error in behavioural data relative to target
values. Requires a data frame that (at least) has target value data and
participant response data.
}
\examples{
plot_error(bays2009_full,
          unit = "radians",
          set_size_var = "set_size")

}
