% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fupper.R
\name{fupper}
\alias{fupper}
\title{Calculate fupper for Different Components}
\usage{
fupper(x, r, mu, sigma, comp, dist = "normal")
}
\arguments{
\item{x}{The value at which to evaluate the function.}

\item{r}{The value of r.}

\item{mu}{The mean value.}

\item{sigma}{The standard deviation.}

\item{comp}{The component number (1 to 7).}

\item{dist}{string; assumed distribution of the serial interval; accepts "normal" or "gamma"; defaults to "normal".}
}
\value{
The calculated value of fupper.
}
\description{
This function calculates the value of fupper based on the component.
}
\examples{
# Basic example with normal distribution
# Component 2 represents primary-secondary transmission
fupper(x = 15, r = 20, mu = 12, sigma = 3, comp = 2, dist = "normal")

# Same parameters with gamma distribution
fupper(x = 15, r = 20, mu = 12, sigma = 3, comp = 2, dist = "gamma")

# Component 1 represents co-primary transmission
fupper(x = 5, r = 25, mu = 8, sigma = 2, comp = 1, dist = "normal")

# Calculate for all transmission route components
x_val <- 10
r_val <- 30
mu_val <- 12
sigma_val <- 3

# Components 1-7 represent different transmission routes
sapply(1:7, function(comp) {
  fupper(x_val, r_val, mu_val, sigma_val, comp, "normal")
})
}
