% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intervals.R
\name{gintervals.load_chain}
\alias{gintervals.load_chain}
\title{Loads assembly conversion table from a chain file}
\usage{
gintervals.load_chain(file = NULL)
}
\arguments{
\item{file}{name of chain file}
}
\value{
A data frame representing assembly conversion table.
}
\description{
Loads assembly conversion table from a chain file.
}
\details{
This function reads a file in 'chain' format and returns assembly conversion
table that can be used in 'gtrack.liftover' and 'gintervals.liftover'.

Note: chain file might map a few different source intervals into a single
target one. These ambiguous mappings are not presented in the data frame
returned by 'gintervals.load_chain'.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()
chainfile <- paste(.misha$GROOT, "data/test.chain", sep = "/")
gintervals.load_chain(chainfile)

}
\seealso{
\code{\link{gintervals.liftover}}, \code{\link{gtrack.liftover}}
}
\keyword{~chain}
\keyword{~intervals}
\keyword{~liftover}
