% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clipping.R
\name{pdf_clip_polygon}
\alias{pdf_clip_polygon}
\title{Add a global clipping polygon to a PDF doc}
\usage{
pdf_clip_polygon(doc, xs, ys, id = NULL, rule = "winding", tf = NULL)
}
\arguments{
\item{doc}{A \code{pdf_doc} object created by \code{\link{create_pdf}()}}

\item{xs, ys}{vertex coordinates. Note: polygon will automatically be closed}

\item{id}{A numeric vector used to separate vertices into multiple polygons.
All vertices with the same id belong to the same polygon. Default: NULL
means that all vertices belong to a single polygon.}

\item{rule}{fill rule. 'winding' or 'evenodd'.  Default: 'winding'}

\item{tf}{either a single transform (\code{tf_translate()}, \code{tf_scale()},
\code{tf_rotate()}), or a list of these transforms.  Default: NULL,
no local transformation applied (global transformations still apply)}
}
\value{
\code{pdf_doc}
}
\description{
Clipping regions are cumulative, and these is no operation to expand the 
global clipping region.
use local clipping with the \code{clip} argument to individual objects.
}
\examples{
doc <- create_pdf() |>
   pdf_clip_polygon(xs = c(0, 100, 100), ys = c(0, 0, 100))
}
\seealso{
Other clipping functions: 
\code{\link{clip_polygon}()},
\code{\link{clip_rect}()},
\code{\link{pdf_clip_rect}()}

Other global clipping functions: 
\code{\link{pdf_clip_rect}()}
}
\concept{clipping functions}
\concept{global clipping functions}
