% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr_feats.R
\name{cluster_corr_mat}
\alias{cluster_corr_mat}
\title{Cluster a matrix of correlated features}
\usage{
cluster_corr_mat(bin_corr_mat, hclust_method = "single", cut_height = 0)
}
\arguments{
\item{bin_corr_mat}{a binary correlation matrix created by \code{get_binary_corr_mat()}.}

\item{hclust_method}{the \code{method} to use in \code{stats::hclust()} (default: 'single').}

\item{cut_height}{the cut height (\code{h}) to use in \code{stats::cutree()} (default: 0).}
}
\value{
a named vector from \code{stats::cutree()}. Each element is a cluster and
the name is a feature in that cluster.
}
\description{
Cluster a matrix of correlated features
}
\examples{
\dontrun{
corr_mat <- matrix(
  data = c(1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1, 1, 0, 0, 1, 1),
  nrow = 4,
  dimnames = list(
    c("a", "b", "c", "d"),
    c("a", "b", "c", "d")
  )
)
corr_mat
cluster_corr_mat(corr_mat)
}
}
\author{
Kelly Sovacool, \email{sovacool@umich.edu}

Pat Schloss, \email{pschloss@umich.edu}
}
\keyword{internal}
