% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort.R
\name{sort_by_key}
\alias{sort_by_key}
\title{Sort Rows by Key Sequence}
\usage{
sort_by_key(data, metacore, dataset_name = deprecated())
}
\arguments{
\item{data}{Dataset to sort}

\item{metacore}{metacore object that contains the specifications for the
dataset of interest.}

\item{dataset_name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Optional string to
specify the dataset that is being built. This is only needed if the metacore
object provided hasn't already been subsetted.\cr
Note: Deprecated in version 0.2.0. The \code{dataset_name} argument will be removed
in a future release. Please use \code{metacore::select_dataset} to subset the
\code{metacore} object to obtain metadata for a single dataset.}
}
\value{
dataset with ordered columns
}
\description{
This function sorts the dataset according to the key sequence found in the
metacore object.
}
\examples{
library(metacore)
library(haven)
library(magrittr)
load(metacore_example("pilot_ADaM.rda"))
spec <- metacore \%>\% select_dataset("ADSL")
data <- read_xpt(metatools_example("adsl.xpt"))
sort_by_key(data, spec)
}
