% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manhattan_plot.R
\name{var_manhattan_plot}
\alias{var_manhattan_plot}
\title{Manhattan plot of feature-feature association p-values}
\usage{
var_manhattan_plot(
  dl,
  key_var,
  neg_log_pval_thresh = 5,
  threshold = NULL,
  point_size = 5,
  text_size = 20,
  plot_title = NULL,
  hide_x_labels = FALSE,
  bonferroni_line = FALSE
)
}
\arguments{
\item{dl}{List of data frames containing data information.}

\item{key_var}{Feature for which the association p-values of all other
features are plotted.}

\item{neg_log_pval_thresh}{Threshold for negative log p-values.}

\item{threshold}{p-value threshold to plot dashed line at.}

\item{point_size}{Size of points in the plot.}

\item{text_size}{Size of text in the plot.}

\item{plot_title}{Title of the plot.}

\item{hide_x_labels}{If TRUE, hides x-axis labels.}

\item{bonferroni_line}{If TRUE, plots a dashed black line at the
Bonferroni-corrected equivalent of the p-value threshold.}
}
\value{
A Manhattan plot (class "gg", "ggplot") showing the association
p-values of features against one key feature in a data list.
}
\description{
Manhattan plot of feature-feature association p-values
}
\examples{
dl <- data_list(
    list(subc_v, "subcortical_volume", "neuroimaging", "continuous"),
    list(income, "household_income", "demographics", "continuous"),
    list(pubertal, "pubertal_status", "demographics", "continuous"),
    list(anxiety, "anxiety", "behaviour", "ordinal"),
    list(depress, "depressed", "behaviour", "ordinal"),
    uid = "unique_id"
)

var_manhattan <- var_manhattan_plot(
    dl,
    key_var = "household_income",
    plot_title = "Correlation of Features with Household Income",
    text_size = 16,
    neg_log_pval_thresh = 3,
    threshold = 0.05
)
}
