% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmaps.R
\name{pval_heatmap}
\alias{pval_heatmap}
\title{Heatmap of p-values}
\usage{
pval_heatmap(
  ext_sol_df,
  order = NULL,
  cluster_columns = TRUE,
  cluster_rows = FALSE,
  show_row_names = FALSE,
  show_column_names = TRUE,
  min_colour = "red2",
  max_colour = "white",
  legend_breaks = c(0, 1),
  col = circlize::colorRamp2(legend_breaks, c(min_colour, max_colour)),
  heatmap_legend_param = list(color_bar = "continuous", title = "p-value", at = c(0, 1)),
  rect_gp = grid::gpar(col = "black"),
  column_split_vector = NULL,
  row_split_vector = NULL,
  column_split = NULL,
  row_split = NULL,
  ...
)
}
\arguments{
\item{ext_sol_df}{An ext_solutions_df class object (produced from
the function \code{extend_solutions}.}

\item{order}{Numeric vector containing row order of the heatmap.}

\item{cluster_columns}{Whether columns should be sorted by hierarchical
clustering.}

\item{cluster_rows}{Whether rows should be sorted by hierarchical
clustering.}

\item{show_row_names}{Whether row names should be shown.}

\item{show_column_names}{Whether column names should be shown.}

\item{min_colour}{Colour used for the lowest value in the heatmap.}

\item{max_colour}{Colour used for the highest value in the heatmap.}

\item{legend_breaks}{Numeric vector of breaks for the legend.}

\item{col}{Colour function for \code{ComplexHeatmap::Heatmap()}}

\item{heatmap_legend_param}{Legend function for \code{ComplexHeatmap::Heatmap()}}

\item{rect_gp}{Cell border function for \code{ComplexHeatmap::Heatmap()}}

\item{column_split_vector}{Vector of indices to split columns by.}

\item{row_split_vector}{Vector of indices to split rows by.}

\item{column_split}{Standard parameter of \code{ComplexHeatmap::Heatmap}.}

\item{row_split}{Standard parameter of \code{ComplexHeatmap::Heatmap}.}

\item{...}{Additional parameters passed to \code{ComplexHeatmap::Heatmap}.}
}
\value{
Returns a heatmap (class "Heatmap" from package ComplexHeatmap)
that displays the provided p-values.
}
\description{
Heatmap of p-values
}
\examples{
\donttest{
dl <- data_list(
    list(income, "household_income", "demographics", "ordinal"),
    list(pubertal, "pubertal_status", "demographics", "continuous"),
    list(fav_colour, "favourite_colour", "demographics", "categorical"),
    list(anxiety, "anxiety", "behaviour", "ordinal"),
    list(depress, "depressed", "behaviour", "ordinal"),
    uid = "unique_id"
)

sc <- snf_config(
    dl,
    n_solutions = 4,
    dropout_dist = "uniform",
    max_k = 50
)

sol_df <- batch_snf(dl, sc)

ext_sol_df <- extend_solutions(sol_df, dl)

pval_heatmap(ext_sol_df)
}
}
