% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operate_inequalities.R
\name{operate_inequalities}
\alias{operate_inequalities}
\alias{<.mdate}
\alias{>.mdate}
\alias{<=.mdate}
\alias{>=.mdate}
\title{Logical operations on messy dates}
\usage{
\method{<}{mdate}(e1, e2)

\method{>}{mdate}(e1, e2)

\method{<=}{mdate}(e1, e2)

\method{>=}{mdate}(e1, e2)
}
\arguments{
\item{e1, e2}{\code{mdate} or other class objects}
}
\description{
Logical operations on messy dates
}
\section{Functions}{
\itemize{
\item \code{ < }: tests whether the dates in the first vector precede
the dates in the second vector.
Returns \code{NA} when the date order can't be determined.

\item \code{ > }: tests whether the dates in the first vector
succeed the dates in the second vector.
Returns \code{NA} when the date order can't be determined.

\item \code{ <= }: tests whether the dates in the first vector are
equal to or precede the dates in the second vector.
Returns \code{NA} when the date order can't be determined.

\item \code{ >= }: tests whether the dates in the first vector are equal to
or succeed the dates in the second vector.
Returns \code{NA} when the date order can't be determined.

}}
\examples{
as_messydate("2012-06-02") > as.Date("2012-06-01") # TRUE
# 2012-06-XX could mean 2012-06-03, so unknown if it comes before 2012-06-02
as_messydate("2012-06-XX") < as.Date("2012-06-02") # NA
# But 2012-06-XX cannot be before 2012-06-01
as_messydate("2012-06-XX") >= as.Date("2012-06-01") # TRUE
}
