% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{computeDesignMatrix}
\alias{computeDesignMatrix}
\title{Compute a list of design matrices for all terms in a model formula,
or based on a sampler environment}
\usage{
computeDesignMatrix(formula = NULL, data = NULL, labels = TRUE)
}
\arguments{
\item{formula}{model formula.}

\item{data}{data frame to be used in deriving the design matrices.}

\item{labels}{if \code{TRUE}, column names are assigned.}
}
\value{
A list of design matrices.
}
\description{
If \code{sampler} is provided instead of \code{formula}, the design matrices
are based on the model used to create the sampler environment. In that case, if
\code{data} is \code{NULL}, the design matrices stored in \code{sampler} are returned,
otherwise the design matrices are computed for the provided data based on the sampler's model.
The output is a list of dense or sparse design matrices for the model components
with respect to \code{data}.
}
\examples{
n <- 1000
dat <- data.frame(
  x = rnorm(n),
  f = factor(sample(1:50, n, replace=TRUE))
)
str(computeDesignMatrix(~ x, dat)[[1]])
model <- ~ reg(~x, name="beta") + gen(~x, factor=~f, name="v")
X <- computeDesignMatrix(model, dat)
str(X)

}
