% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matsindf_apply.R
\name{get_useable_default_args}
\alias{get_useable_default_args}
\title{Create a usable list of default arguments to a function}
\usage{
get_useable_default_args(FUN, which = c("values", "names"), no_default = NULL)
}
\arguments{
\item{FUN}{A function from which values of default arguments are to be extracted.}

\item{which}{Tells whether to get "names" of arguments or "values" of arguments.
Default is "values".}

\item{no_default}{The placeholder value for arguments with no default.}
}
\value{
A named list of default arguments to \code{FUN}.
Names are the argument names.
Values are the default argument values.
}
\description{
\code{formals(FUN)} does not handle arguments without a default well,
returning a \code{name} vector of length \code{1},
which when converted to character is "".
This function detects that condition and replaces the no-default argument with
the value of \code{.no_default}, by default \code{NULL}.
}
\examples{
f <- function(a = 42, b) {
  return(a + b)
}
matsindf:::get_useable_default_args(f)
matsindf:::get_useable_default_args(f, no_default = logical())
}
