% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maraca.R
\name{validate_maraca_plot}
\alias{validate_maraca_plot}
\title{Generic function to generate validation data for the maraca plot object.}
\usage{
validate_maraca_plot(x, ...)
}
\arguments{
\item{x}{An object of S3 class 'maracaPlot'.}

\item{\dots}{Not used.}
}
\value{
Creates a list of datasets for validation purposes.
}
\description{
This will produce the 4 validation datasets.
}
\examples{
data(hce_scenario_a)
hce_test <- maraca(
  data = hce_scenario_a,
  step_outcomes = c("Outcome I", "Outcome II", "Outcome III", "Outcome IV"),
  last_outcome = "Continuous outcome",
  fixed_followup_days = 3 * 365,
  column_names = c(outcome = "GROUP", arm = "TRTP", value = "AVAL0"),
  arm_levels = c(active = "Active", control = "Control"),
  compute_win_odds = TRUE
)
p <- plot(hce_test)
validate_maraca_plot(p)

}
