% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register.R
\name{resources}
\alias{resources}
\alias{register_resource}
\alias{available_resources}
\title{Register or list resources in mapme.biodiversity}
\usage{
register_resource(
  name = NULL,
  description = NULL,
  licence = NULL,
  source = NULL,
  type = NULL
)

available_resources(resources = NULL)
}
\arguments{
\item{name}{A character vector indicating the name of the resource.}

\item{description}{A character vector with a basic description}

\item{licence}{A character vector indicating the licence of the resource.
In case it is a custom licence, put a link to the licence text.}

\item{source}{Optional, preferably a URL where the data is found.}

\item{type}{A character vector indicating the type of the resource. Either
'vector' or 'raster'.}

\item{resources}{If \code{NULL} returns a list of all resources (default).
Otherwise only the ones specified.}
}
\value{
\code{register_resource()} is called for the side-effect of registering a
resource.

\code{available_resources()} returns a tibble listing available resources.
}
\description{
\code{register_resource()} is used to register a new resource function with base
information to the package's internal environment used to inform users about
available resources. Note, registering a custom resource will
only have effect for the current R session.

\code{available_resources()} returns a tibble of registered resources with basic
information such as the source and the licence.
}
\examples{
\dontrun{
register_resource(
  name = "gfw_treecover",
  description = "Global Forest Watch - Percentage of canopy closure in 2000",
  licence = "CC-BY 4.0",
  source = "https://data.globalforestwatch.org/documents/tree-cover-2000/explore",
  type = "raster"
)
}
available_resources()
}
