% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_helpers.R
\name{add_covariates}
\alias{add_covariates}
\alias{add_covariates.data.frame}
\alias{add_covariates.mrgmod}
\title{Add covariate columns to a dataset}
\usage{
add_covariates(x, ...)

\method{add_covariates}{data.frame}(x, ..., covariates = list(), AOLA = FALSE, TOLA = FALSE)

\method{add_covariates}{mrgmod}(x, ..., covariates = list(), AOLA = NULL, TOLA = NULL)
}
\arguments{
\item{x}{either a data.frame or a 'mrgsolve' model object}

\item{...}{covariates values to add to the data. For each variable, supply a vector of length 1 or with the same number of rows. Ignored if \code{covariates} argument is used.}

\item{covariates}{Covariates passed as a single list of variables. Overrides \code{...}.}

\item{AOLA, TOLA}{a logical. Should the "Amount Of Last Administration" and "Time Of Last Administration" variables be added into the dataset? Default if FALSE if \code{x} is a dataset, TRUE if \code{x} is a 'mrgsolve' model where \code{AOLA} and \code{TOLA} are defined as covariates}
}
\value{
a data.frame, or a 'mrgsolve' model with a dataset in the \verb{@args$data} slot (accessible with \code{\link[=get_data]{get_data()}}).
}
\description{
The \code{add_covariates()} function adds an one or several covariate columns to a dataset provided as a proper data.frame or within a 'mrgsolve' model. Used in combination with \code{\link[=adm_rows]{adm_rows()}} and \code{\link[=obs_rows]{obs_rows()}}, it helps the creation of datasets in the proper format for simulations with 'mrgsolve' or parameter estimation with 'mapbayr', as explained in \link{data_helpers}.
}
\examples{
# Cannot start from scratch
\dontrun{
add_covariates(BW = 90, SEX = 0)
}

library(magrittr)
adm_rows(time = c(0, 24, 48), cmt = 1, amt = c(100, 200, 300)) \%>\%
  add_covariates(BW = c(90, 85, 80), SEX = 0)

# If covariates are stored in a list, use `covariates = `
adm_rows(time = c(0, 24, 48), cmt = 1, amt = c(100, 200, 300)) \%>\%
  add_covariates(covariates = list(BW = c(90, 85, 80), SEX = 0))

# Missing values are filled with the "next observation carried backward" rule
adm_rows(time = c(0, 24, 48), cmt = 1, amt = c(100, 200, 300)) \%>\%
  add_covariates(BW = c(90, 85, 80), SEX = 0) \%>\%
  obs_rows(time = 36, DV = .0123, cmt = 2)
# Always verify the output in case of time-varying covariates

# Possibility to add Time and Amount of last administration as covariates
adm_rows(time = c(0, 24, 48), amt = c(100, 200, 300), cmt = 1) \%>\%
  obs_rows(time = c(8, 16, 32, 40), cmt = 2, DV = runif(4)) \%>\%
  add_covariates(TOLA = TRUE, AOLA = TRUE) \%>\%
  obs_rows(time = 72, cmt = 2, DV = .123) # AOLA/TOLA re-updated afterwards

# Automatic inclusion of `TOLA`/`AOLA` if they are covariates of the model
library(mrgsolve)
model <- mcode("model", "
$PARAM @annotated @covariates
TOLA : 0 : Time Last Adm
AOLA : 0 : Amount Last Adm
", compile = FALSE)

model \%>\%
  adm_rows(time = c(0, 24, 48), amt = c(100, 200, 300), cmt = 1) \%>\%
  add_covariates() \%>\%
  get_data()
}
\seealso{
\link{data_helpers}
}
