% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{pedigree_haplotype_near_matches_meiosis}
\alias{pedigree_haplotype_near_matches_meiosis}
\title{Information about almost matching individuals}
\usage{
pedigree_haplotype_near_matches_meiosis(
  suspect,
  max_dist,
  generation_upper_bound_in_result = -1L
)
}
\arguments{
\item{suspect}{Individual that others must match the profile of.}

\item{max_dist}{Maximum distance (0 = match, 1 = 1 STR allele difference, ...)}

\item{generation_upper_bound_in_result}{Only consider matches in
generation 0, 1, ... generation_upper_bound_in_result.
-1 means disabled, consider all generations.
End generation is generation 0.
Second last generation is 1.
And so on.}
}
\value{
Matrix with information about matching individuals.
Columns in order: 1) meioses (meiotic distance to \code{suspect}),
2) haplotype distance, 3) pid (pid of matching individual)
}
\description{
Gives information about all individuals in pedigree that almost matches
an individual.
Just as \code{\link[=count_haplotype_near_matches_individuals]{count_haplotype_near_matches_individuals()}} counts the number of
occurrences amongst a list of individuals,
this gives detailed information about almost matching individuals in
the pedigree: for now, the meiotic distances.
}
\seealso{
\code{\link[=count_haplotype_near_matches_individuals]{count_haplotype_near_matches_individuals()}}.
}
